LIBRARY    = lib$(LIBNAME).a
LIBRARY_SO = lib$(LIBNAME).so

CFLAGS   = -g -pipe -O2 -Wall
CPPFLAGS = $(addprefix -I, $(INC_DIRS))
ARFLAGS  = r
PIC_OPT  = -fPIC

# generate OBJS automatically.  Do not put spaces between ".c" and ".o"
OBJS   = $(subst .c,.o, $(SRCS))
SHOBJS = $(subst .c,.so, $(SRCS))

$(LIBRARY): $(OBJS)
	$(AR) $(ARFLAGS) $@ $^

$(LIBRARY_SO): $(SHOBJS)
	$(CC) -shared -o $(LIBRARY_SO) $(SHOBJS)

.SUFFIXES: .so
.c.so:
	rm -f $@
	$(CC) $(CPPFLAGS) -c ${CFLAGS} $(PIC_OPT) -o $*.so $< 

clean:
	rm -f $(LIBRARY) $(OBJS) $(LIBRARY_SO) $(SHOBJS)

INSTALL_DIR = ../../../lib

install:
	mkdir -p $(INSTALL_DIR)
	install -m 0644 $(TARGET) $(INSTALL_DIR)
