/* 
 * API: is_in_range("12345", 3);
 *
 * if the numstr exceeds the max integer that can hold in len bytes
 * return -1.  Else return 0.
 *
 */

#include <err.h>
#include <errno.h>
#include <stdlib.h>
#include <stdio.h>

int is_in_range(const char *numstr, unsigned int len)
{
	int i;
	unsigned long long l, max;
	errno = 0;

	if (len > 8) {
		errno = ERANGE;
		return -1;
	}

	max = 1;
	for (i = 0; i < len; i++) {
		max = 256 * max;
	}
	max -= 1;

	l = strtoull(numstr, NULL, 0);
	if (errno == EINVAL || errno == ERANGE) {
		return -1;
	}

	if (l > max) {
		errno = ERANGE;
		return -1;
	}

	return 0;
}

/* sample */
/*
int main(int argc, char *argv[])
{
	if (is_in_range("16777215", 8) < 0) {
		err(1, "range");
	}
	else {
		fprintf(stderr, "ok\n");
	}

	return 0;
}
*/
