#include <err.h>
#include <stdio.h>

#include "psdmodule.h"
#include "pm_reg.h"

int pm_read_register(char *ip_address, register_info *ri, unsigned char *buf)
{
	int rv = 0;
	int status, retlen, length, offset_address;
	psd_header header;
	sitcpbcp_header *sitcpbcp_header;
	int udp_port = 0x1234;

    status = psd_control_init(&header, ip_address, udp_port,
                MAX_BUF + sizeof(bcp_header));
    if (status < 0) {
        if (status == ERROR_TIMEOUT) {
            //errx(1, "psd_init timeout");
			rv = -2;
			goto END;
        }
        else {
            //errx(1, "psd_init fatal error");
			rv = -1;
			goto END;
        }
    }

    length          = ri->length;
    offset_address  = ri->address;
    sitcpbcp_header = &header.sitcpbcp_header;
    status = sitcpbcp_read_registers(sitcpbcp_header, offset_address,
                buf, length, &retlen);
    if (status < 0) {
        if (status == ERROR_TIMEOUT) {
            //errx(1, "sitcpbcp_read_registers time out");
			rv = -2;
			goto END;
        }
        else {
            //errx(1, "sitcpbcp_read_registers fatal error");
			rv = -1;
			goto END;
        }
    }

END:
	psd_control_exit(&header);
	return rv;
}
