#ifndef _PM_REG_H
#define _PM_REG_H 1

/*************************************************************************
 * Register Data Structure
 * name:      name of the register.  This name will be used as search key.
 * address:   offset address of the register.
 * length:    length of the register in byte size.
 * can_write: Wheather the register is RO (0) or RW (1).
 * n_val:     The number of values values to set the register.
 * enc:       pointer to a function to encode input numeric data to buffer.
 * dec:       pointer to a function to decode return buffer to numeric
 *            or string data.
 * verify:    pointer to a function to verify whether we can set correctly.
 *************************************************************************/

#define MAX_BUF       1024*2
#define YES           1
#define NO            0
#define PSD_EPOCH	  1199145600 /* Jan. 1, 2008 00:00:00 JST */

typedef struct register_info_tag {
    char *  name;
    int     address;
    int     length;
    int     can_write;
    int     n_val;
    int     (*dec)(unsigned char *, int);
    int     (*enc)(unsigned char *, int, char **, int);
	int		(*verify)(unsigned char *, unsigned char *,
					  struct register_info_tag *);
} register_info;

extern int pm_reg_debug;
extern register_info register_info_list[];

extern int is_in_range(char *, int);
extern int pm_read_register(char *, register_info *, unsigned char *);
extern int pm_write_register(char *, register_info *, unsigned char *);
extern register_info *lookup_register(char *, int, register_info *);

//extern int verify_wrapper(unsigned char *, unsigned char *, register_info *);
#endif
