#include <stdlib.h>
#include <stdio.h>
#include "psdmodule.h"
#define MAX_BUF 1024*2

unsigned int packet[MAX_BUF/sizeof(int)]; 

int main(int argc, char** argv) {

  int status;
  int length, retlen;
  int offsetAddress;
  int tcp_port, udp_port;
  char buffer[128+1]; // size of  NEUNET registers
  psd_header header;
  psd_response response;
  sitcpbcp_header* sitcpbcp_header;
  char comment[40];

  if(argc < 2) {
    printf("usage: ./getComment ip_address[192.168.0.17]\n");
    exit(1);
  }

  udp_port = PSD_PORT_UDP;
  status = psd_control_init(&header, argv[1], udp_port, MAX_BUF+sizeof(bcp_header));
  if(status) {
    if(status == ERROR_TIMEOUT)
      printf("psd_init:Timeout error...\n");
    else 
      printf("psd_init:fatal error...\n");
    exit(1);
  }
  length = PSD_SIZE_COMMENT;
  offsetAddress = PSD_ADDR_COMMENT;
  sitcpbcp_header = &header.sitcpbcp_header;
  sitcpbcp_read_registers(sitcpbcp_header, offsetAddress,
			  buffer, length, &retlen);
  
  extract_comment(buffer, comment);
  printf("Comment = %s\n", comment);

  psd_control_exit(&header);

  return 0;
}

