#include <stdlib.h>
#include <stdio.h>
#include "psdmodule.h"
#define MAX_BUF 1024*40

unsigned int packet[MAX_BUF/sizeof(int)]; 

int main(int argc, char** argv) {

  int length, retlen, len;
  int i, j;
  int status;
  unsigned int time;
  unsigned char psd;
  unsigned short pulse_left;
  unsigned short pulse_right;
  int tcp_port, udp_port;
  psd_header header;
  psd_response response;

  tcp_port = 23;
  status = psd_data_init(&header, "192.168.0.19", tcp_port, MAX_BUF);
  if(status) {
    if(status == ERROR_TIMEOUT)
      printf("psd_init:Timeout error...\n");
    else 
      printf("psd_init:fatal error...\n");
    exit(1);
  }

  for(i=0; i<1; i++) {
    printf("loop count = %d\n", i);
    do {
      status = psd_write_length(&header);
      if(status) {
	printf("psd_write_length:fatal error...\n");
	exit(1);
      }
      status = psd_read_length(&header, &retlen);
      if(status) {
	printf("psd_read_length:fatal error...\n");
	exit(1);
      }
    } while (retlen == 0);
    printf("actual length of data to be able to be sent = %d in bytes(decimal) %x in bytes(hex)\n", retlen, retlen);

    length = retlen;
    status = psd_read_event(&header, packet, length, &retlen);
    printf("psdtest:psd_read_event:return status = %d\n", status);
    printf("psdtest:psd_read_event:return length = %d\n", retlen);
    if(status == ERROR_FATAL) {
      printf("psd_read_event_data:fatal error...\n");
      exit(1);
    }
    if(status == ERROR_TIMEOUT) {
      printf("psd_read_event_data:timeout error...\n");
      exit(1);
    }

    length = retlen;
    for(j=0; j<retlen/sizeof(int) ; j += 2) { // event size is sizeof(int)*2
      psd_unpack_tcp(&packet[j], &response);

      if(psd_isEventData(&response)) {
	psd_extract_event_data(&response,
			       &time, &psd, &pulse_left, &pulse_right);
	printf("time = %6x ", time);
	printf("psd = %2x ", psd);
	printf("pulse_left  = %3x ", pulse_left);
	printf("pulse_right = %3x\n", pulse_right);
      }
      else
	printf("this is not event data...\n");
    }
  }
  psd_data_exit(&header);

  return 0;
}

