#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include "psdmodule.h"

#define MAX_BUF 1024*2

void print_time(time_t* time) {
  struct tm *lt;
  lt = localtime(time);
  printf("%04d/%02d/%02d-%02d:%02d:%02d\n", lt->tm_year+1900, lt->tm_mon+1,
	 lt->tm_mday, lt->tm_hour, lt->tm_min, lt->tm_sec);
}

unsigned int packet[MAX_BUF/sizeof(int)]; 

int main(int argc, char** argv) {

  int status;
  int length, retlen;
  int offsetAddress;
  int tcp_port, udp_port;
  char buffer[128+1]; // size of  NEUNET registers
  psd_header header;
  psd_response response;
  sitcpbcp_header* sitcpbcp_header;
  char mac_address[6];
  unsigned long long kp;
  time_t time;

  udp_port = PSD_PORT_UDP;
  if(argc != 3) {
    printf("usage: ./setExtClk ip_address[192.168.0.17] KP\n");
    exit(1);
  }

  status = psd_control_init(&header, argv[1], udp_port, 
			    MAX_BUF+sizeof(bcp_header));
  if(status) {
    if(status == ERROR_TIMEOUT)
      printf("psd_init:Timeout error...\n");
    else 
      printf("psd_init:fatal error...\n");
    exit(1);
  }
  kp =(unsigned long long)atoi(argv[2]);
  set_kp(buffer, kp);
  printf("KP = %llx\n", kp);
  length = PSD_SIZE_EXT_CNT; // register size is 5 bytes.
  offsetAddress = PSD_ADDR_EXT_CNT; // offset(0x1A0) of external clock counter
  sitcpbcp_header = &header.sitcpbcp_header;
  sitcpbcp_write_registers(sitcpbcp_header, offsetAddress,
			  buffer, length, &retlen);
  

  psd_control_exit(&header);

  return 0;
}

