#include <stdlib.h>
#include <stdio.h>
#include "psdmodule.h"
#define MAX_BUF 1024*2

unsigned int packet[MAX_BUF/sizeof(int)]; 

int main(int argc, char** argv) {

  int status;
  int length, retlen;
  int offsetAddress;
  int tcp_port, udp_port;
  char buffer[128+1]; // size of  NEUNET registers
  psd_header header;
  psd_response response;
  sitcpbcp_header* sitcpbcp_header;
  char mac_address[6];
  unsigned int lld, timeh, timel;

  udp_port = PSD_PORT_UDP;
  if(argc !=5) {
    printf("usage: ./setLLDTime ip_address[192.168.0.17] lld[0-4095] time_low(25ns,0~16777217) time_hi(25ns,0~16777217)\n");
    exit(1);
  }

  status = psd_control_init(&header, argv[1], udp_port, 
			    MAX_BUF+sizeof(bcp_header));
  if(status) {
    if(status == ERROR_TIMEOUT)
      printf("psd_init:Timeout error...\n");
    else 
      printf("psd_init:fatal error...\n");
    exit(1);
  }

  lld = atoi(argv[2]);
  timeh = atoi(argv[3]);
  timel = atoi(argv[4]);
  set_lld_timeh_timel(buffer, lld, timeh, timel);
  printf("lld = %x  timeh = %x  timel = %x\n", lld, timeh, timel);

  length = PSD_SIZE_LLD_TIME; // register size is 8 bytes.
 // offset of lld and time limit( high & low )
  offsetAddress = PSD_ADDR_LLD_TIME;
  sitcpbcp_header = &header.sitcpbcp_header;
  sitcpbcp_write_registers(sitcpbcp_header, offsetAddress,
			  buffer, length, &retlen);
  
  psd_control_exit(&header);

  return 0;
}

