/*
psdmodule.h
*/
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <arpa/inet.h>

struct read_len {
  unsigned int length;
  unsigned char dummy[3];
  unsigned char cmd;
};
struct mem_ctrl {
  unsigned char dummy[4];
  unsigned char dl;
  unsigned char dh;
  unsigned char ah;
  unsigned char cmd;
};
typedef union psd_reqqust {
  struct read_len len;
  struct mem_ctrl ctl;
  unsigned char data[8];
} psd_request;

struct event_data {
  unsigned char pulse[3];
  unsigned char psd;
  unsigned char t0[3];
  unsigned char cmd;
};
struct t0_data {
  unsigned char k[5];
  unsigned char m;
  unsigned char c;
  unsigned char cmd;
};
typedef union psd_response {
  struct event_data event;
  struct t0_data t0;
  unsigned char data[8];
} psd_response;

int main(int argc, char** argv) {
  int i, j;
  psd_request psd_request;
  psd_response psd_response;
  uint32_t nl;
  char* str;
  int data;

  printf("sizeof(psd_request) = %d\n", sizeof(psd_request));
  printf("sizeof(psd_response) = %d\n", sizeof(psd_response));

  for(i=0; i<8; i++)
    psd_request.data[i] = 0;
  psd_request.len.cmd = 0xa3;
  psd_request.len.length = 0x12345678;
  printf("psd_request.len.length = %x\n", psd_request.len.length);

  printf("host order data format = ");
  for(i=0; i<8; i++)
    printf("%x ", psd_request.data[i]);
  printf("\n");

  printf("network order data format = ");
  for(i=1;i>=0;i--) {
    memcpy((char*)&nl, &psd_request.data[4*i], 4);
    nl = htonl(nl);
    str = (char*)&nl;
    for(j=0; j<4; j++)
      printf("%2x ", (unsigned char)str[j]);
    printf(" ");
  }
  printf("\n");

  /*
  data = 0x89abcdef;
  str = (char*)&data;
  for(j=0; j<4; j++)
    printf("%2x ", (unsigned char)str[j]);
  printf(" ");
  nl = htonl(data);
  str = (char*)&nl;
  for(j=0; j<4; j++)
    printf("%2x ", (unsigned char)str[j]);
  printf("\n");
  */

  psd_request.ctl.cmd = 0xa2;
  psd_request.ctl.dl = 0xcc;
  printf("psd_request.ctl.dl = %x\n", psd_request.ctl.dl);
  for(i=0; i<8; i++)
    printf("%x ", psd_request.data[i]);
  printf("\n");

  for(i=0; i<8; i++)
    psd_response.data[i] = 0;

  psd_response.event.psd = 1;
  psd_response.event.cmd = 0x5a;
  printf("psd_response.event.psd = %d\n",
	 psd_response.event.psd);
  for(i=0; i<8; i++)
    printf("%x ", psd_response.data[i]);
  printf("\n");

  psd_response.t0.c = 7;
  psd_response.t0.cmd = 0x5b;
  printf("psd_response.t0.c = %d\n",
	 psd_response.t0.c);
  for(i=0; i<8; i++)
    printf("%x ", psd_response.data[i]);
  printf("\n");
}
