/*
 psdmodule.c: C package
*/
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "psdmodule.h"

int psdmodule_debug = 0;

int psd_control_init( psd_header* psd_header,
	      char* ip_address, int udp_port, unsigned int maxBuf) {
  int status;
  sitcpbcp_header* sitcpbcp_header;

  memset(psd_header, 0, sizeof(psd_header));
  sitcpbcp_header = &psd_header->sitcpbcp_header;

  status = sitcpbcp_open(sitcpbcp_header, ip_address, udp_port, maxBuf);
  if (psdmodule_debug > 0) {
    printf("psd_control_init: sitcpbcp_open done\n");
  }
  if(status)
    return status;
  status = sitcpbcp_connect(sitcpbcp_header);
  if(status)
    return status;
  if (psdmodule_debug > 0) {
    printf("psd_control_init: sitcpbcp_connection done\n");
  }
  return status;
}

int psd_data_init( psd_header* psd_header,
	      char* ip_address, int tcp_port, unsigned int maxBuf) {
  int status;
  sock_header* sock_tcp_header;

  memset(psd_header, 0, sizeof(psd_header));
  sock_tcp_header = &psd_header->sock_tcp_header;
  psd_header->packet =  malloc(maxBuf);
  if( psd_header->packet < 0)
    return ERROR_FATAL;

  sock_open(sock_tcp_header, ip_address, tcp_port);
  if (psdmodule_debug > 0) {
    printf("psd_data_init: sock_open done\n");
  }
  status = sock_connect_tcp(sock_tcp_header);
  if(status)
    return status;
  if (psdmodule_debug > 0) {
    printf("psd_data_init: sock_connect_tcp done\n");
  }
  return status;
}

void psd_control_exit(psd_header* psd_header) {
  sitcpbcp_close(&psd_header->sitcpbcp_header);
}
void psd_data_exit(psd_header* psd_header) {
  sock_close(&psd_header->sock_tcp_header);
  free(psd_header->packet);
}

void psd_setCmd_writeLength(psd_request* request, unsigned int length) {

  request->len.length = length;
  request->len.cmd = PSD_CMD_READ_LEN;
}

void psd_pack_tcp(unsigned int* packet, psd_request* request) {

  packet[0] = (int)request->len.cmd;
  packet[1] = htonl(request->len.length);
  if (psdmodule_debug > 0) {
    printf("psd_pack_tcp:packet[0]=0x%x  packet[1]=0x%x\n",
	 packet[0], packet[1]);
  }
}

void psd_unpack_tcp(unsigned int* packet, psd_response* response) {
  unsigned int c[2];

  //swap_64
  c[0] = ntohl(packet[1]);
  c[1] = ntohl(packet[0]);
  if (psdmodule_debug > 0) {
    printf("psd_pack_tcp:packet[0]=0x%x  packet[1]=0x%x\n",
  	   c[0], c[1]);
  }
  memcpy(response, c, sizeof(psd_response));
}

int psd_isEventData(psd_response* response) {
  if(response->event.cmd == PSD_CMD_EVENT_DATA)
    return 1;
  else
    return 0;
}

int psd_isT0Data(psd_response* response) {
  if(response->t0.cmd == PSD_CMD_T0_DATA)
    return 1;
  else
    return 0;
}

int psd_write_length(psd_header* psd_header) {
  int status;
  // int data;
  psd_request* request;
  sock_header* sock_tcp_header;
  // int retlength;
  unsigned char packet[sizeof(psd_request)];

  sock_tcp_header = &psd_header->sock_tcp_header;
  request = &psd_header->request;
  psd_setCmd_writeLength(request, PSD_WRITE_LEN/sizeof(short)); // in shorts
  psd_pack_tcp((unsigned int*)packet, request);
  status = sock_write_all(sock_tcp_header, packet, sizeof(psd_request));
  if (psdmodule_debug > 0) {
    printf("psd_write_length:sock_write_all:return_value=%d\n", status);
  }
  if((status == ERROR_FATAL) || (status == ERROR_TIMEOUT))
    return status;
  return SUCCESS;
 }

int psd_read_length(psd_header* psd_header, unsigned int* length) {
  int status;
  int data;
  sock_header* sock_tcp_header;

  sock_tcp_header = &psd_header->sock_tcp_header;

  // read length of event data (4 bytes)
  status = sock_read_all(sock_tcp_header, (unsigned char*)&data, 4);
  if((status == ERROR_FATAL) || (status == ERROR_TIMEOUT))
    return status;

  if (psdmodule_debug > 0) {
    printf("psd_read_length: network order %x  host order %x in bytes(hex)\n",
  	   data*2, ntohl(data)*2);
  }
  *length = ntohl(data)*2; // in byte
  return SUCCESS;
}

int psd_read_event(psd_header* psd_header,
                   unsigned int* recvBuf, int length, int* retlen) {
  int status;
  sock_header* sock_tcp_header;

  sock_tcp_header = &psd_header->sock_tcp_header;
  status = sock_read_all(sock_tcp_header, (unsigned char*)recvBuf, length);
  if( (status == ERROR_TIMEOUT) || (status == ERROR_FATAL) )
    return status;
  *retlen = status;
  return SUCCESS;
}

void psd_extract_event_data(psd_response* event_data,
                            unsigned int* time,
                            unsigned char* psd,
                            unsigned short* pulse_left,
                            unsigned short* pulse_right) {

  unsigned int pulse;
  unsigned int t;

  if (psdmodule_debug > 0) {
    printf("psd_extract_event_data: cmd = %x\n", event_data->event.cmd);
  }

  t= 0;
  memcpy((char*)&t, (char*)&event_data->event.t0[0], 3);
  *time = t;
  *psd = event_data->event.psd;
  memcpy((char*)&pulse, (char*)&event_data->event.pulse[0], 4);
  *pulse_right = pulse & 0x0FFF;
  *pulse_left  = (pulse>>12) & 0x0FFF;
}

// access to PSD registers
void extract_mac_address(unsigned char* buf, char* mac_address) {
  memcpy(mac_address, buf, PSD_SIZE_MACADR);
}

void extract_comment(unsigned char* buf, char* comment) {
  memcpy(comment, buf, PSD_SIZE_COMMENT);
}

void extract_used_hour(unsigned char* buf, int* overflow, int* remained) {
  int used_hour;

  //memcpy((void*)used_hour, buf, PSD_SIZE_USED_HOUR);
  memcpy(&used_hour, buf, PSD_SIZE_USED_HOUR);
  *overflow = used_hour & 0xFF;
  used_hour = ntohl(used_hour);
  *remained = used_hour & 0xFFFFFF;
}

void extract_lld_timeh_timel(unsigned char* buf,
			    unsigned int* lld,
			    unsigned int* timeh,
			    unsigned int* timel) {
  unsigned char time[4];
  unsigned short tmps;
  tmps = ntohs(*(unsigned short *)buf);
  *lld = (unsigned int)tmps;

  memcpy(time, buf+2, 3);
  time[3] = 0;
  *timeh = ntohl(*(unsigned int *)time);
  memcpy(time, buf+5, 3);
  *timel = ntohl(*(unsigned int *)time);
}

void set_lld_timeh_timel(unsigned char* buf,
			 unsigned int lld,
			 unsigned int timeh,
			 unsigned int timel) {
  unsigned char time[4];

  *(unsigned short *)buf = (unsigned short)lld;
  *(unsigned int *)time = htonl(timeh);
  memcpy(buf+2, time, 3);
  *(unsigned int *)time = htonl(timel);
  memcpy(buf+5, time, 3);
}

void extract_time(unsigned char* buf, time_t* time) {
  time_t t;
  t = ntohl(*(time_t *)buf);
  // difference between 1970 1/1 0:0: and 2008 1/1 0:0 is 1199145600.
  *time = (t >> 2)+1199145600;

}

int set_time(unsigned char* buf) {
  time_t t;
  t = time(&t);
  if(t == -1)
    return ERROR_FATAL; 
  // difference between 1970 1/1 0:0: and 2008 1/1 0:0 is 1199145600.
  t -= 1199145600;
  *(time_t *)buf = htonl(t);
  return 0;
}

void extract_kp(unsigned char* buf, unsigned long long* kp){
  unsigned int tmp[2];
  unsigned int a;

  tmp[0]=tmp[1]=0;
  memcpy(tmp, buf, 5);

  // network order to host order conversion in 8 bytes
  a = tmp[0];
  tmp[0] = tmp[1];
  tmp[1] = tmp[0];
  tmp[0] = ntohl(tmp[0]);
  tmp[1] = ntohl(tmp[1]);

  // XXX: compiler warning //
  *kp = *(unsigned long long*)tmp;
  //  printf("kp = %llx\n", *kp);
}

void set_kp(unsigned char* buf, unsigned long long kp) {
  unsigned int tmp[2];
  unsigned int a;

  memcpy(tmp, &kp, 8);

  // host order to network order conversion in 8 bytes
  a = tmp[0];
  tmp[0] = tmp[1];
  tmp[1] = a;
  tmp[0] = htonl(tmp[0]);
  tmp[1] = htonl(tmp[1]);

  memcpy(buf, tmp, 5);
}

