/*
psdmodule.h
*/
#ifndef PSDMODULE_H
#define PSDMODULE_H

#include <time.h>
#include "sitcpbcp.h"

/* 
 * psdmodule_debug: if greater than 0, print debug messages in this library
 * Default value is 0 (does not print debug messages).
 */
extern int psdmodule_debug;

// 
struct read_len {
  unsigned int length;
  unsigned char dummy[3];
  unsigned char cmd;
};

//
struct mem_ctrl {
  unsigned char dummy[4];
  unsigned char dl;
  unsigned char dh;
  unsigned char ah;
  unsigned char cmd;
};

// data structure for 
typedef union psd_request {
  struct read_len len;
  struct mem_ctrl ctl;
  unsigned char data[8];
} psd_request;

// data structure of event data from PSD module
struct event_data {
  unsigned char pulse[3];
  unsigned char psd;
  unsigned char t0[3];
  unsigned char cmd;
};
// data structure of T0 information from PSD module
struct t0_data {
  unsigned char k[5];
  unsigned char m;
  unsigned char c;
  unsigned char cmd;
};
// data structure of response data from PSD module
typedef union psd_response {
  struct event_data event;
  struct t0_data t0;
  unsigned char data[8];
} psd_response;

// data structure for handle of psdmodule methods
typedef struct psd_header {
  sitcpbcp_header sitcpbcp_header;
  sock_header sock_tcp_header;
  unsigned char* packet;
  psd_request request;
  psd_response response;
} psd_header;

#define PSD_PORT_TCP         24
#define PSD_PORT_UDP       0x1234 // 4660 in dec.

#define PSD_WRITE_LEN      32792 // in bytes

#define PSD_CMD_READ_LEN   0xa3
#define PSD_CMD_MEM_CTL    0xa2
#define PSD_CMD_EVENT_DATA 0x5a
#define PSD_CMD_T0_DATA    0x5b

// PSD regisgers
#define PSD_ADDR_MACADR  0x40
#define PSD_SIZE_MACADR  6 // in bytes
#define PSD_ADDR_COMMENT 0x52
#define PSD_SIZE_COMMENT 38 // in bytes
#define PSD_ADDR_USED_HOUR 0x9C
#define PSD_SIZE_USED_HOUR    4 // in bytes
#define PSD_ADDR_PULSE_ID_CNT 0x18B
#define PSD_SIZE_PULSE_ID_CNT 5 // in bytes
#define PSD_ADDR_TIMER 0x190
#define PSD_SIZE_TIMER 4 // in bytes
#define PSD_ADDR_LLD_TIME 0x198
#define PSD_SIZE_LLD_TIME 8 // in bytes
#define PSD_ADDR_EXT_CNT 0x1A0
#define PSD_SIZE_EXT_CNT 5

// definition of specific error codes: none

int psd_control_init( psd_header* psd_header,
		      char* ip_address, int udp_port, unsigned int maxBuf);
int psd_data_init( psd_header* psd_header,
		  char* ip_address, int tcp_port, unsigned int maxBuf);
void psd_control_exit(psd_header* psd_header);
void psd_data_exit(psd_header* psd_header);

void psd_setCmd_writeLength(psd_request* request, unsigned int length);
void psd_setCmd_memControl(psd_request* request, unsigned char ah,
			    unsigned short data);
void psd_pack_tcp(unsigned int* packet, psd_request* request);
void psd_unpack_tcp(unsigned int* packet, psd_response* response);

int psd_isEventData(psd_response* response);
int psd_isT0Data(psd_response* response);

// writes length of data to be read and then gets actual length that
// can be sent. 
// The method uses TCP.
int psd_write_length(psd_header* psd_header);
//
int psd_read_length(psd_header* psd_header, unsigned int* length);

// read event data using TCP
int psd_read_event(psd_header* psd_header,
		   unsigned int* recvdBuf, int length, int* retlen);
// event_data has 64 bits using TCP
void psd_extract_event_data(psd_response* event_data,
			    unsigned int* time,
			    unsigned char* psd,
			    unsigned short* pulse_left,
			    unsigned short* pulse_right);
// event_data has 64 bits using TCP
void psd_extract_t0_data(psd_response* t0_data,
			 unsigned char* crate,
			 unsigned char* module,
			 unsigned int* kh, unsigned int* kl);

// for UDP
// pack header for register access using UDP
void psd_pack(psd_header* psd_header, unsigned int* buffer, int length);

// access to PSD registers
void extract_mac_address(unsigned char* buf, char* mac_address);
void extract_comment(unsigned char* buf, char* comment);
void extract_used_hour(unsigned char* buf, int* overflow, int* remained);
void extract_pulse_id_count(unsigned char* buf, int* count);

// LLD and Time at location 408(0x198)
void extract_lld_timeh_timel(unsigned char* buf,
			     unsigned int* lld,
			     unsigned int* timeh,
			     unsigned int* timel);
void set_lld_timeh_timel(unsigned char* buf,
			     unsigned int lld,
			     unsigned int timeh,
			     unsigned int timel);

// Pulse ID counter at location 395(0x18B)
void extract_kp(unsigned char* buf, unsigned long long* kp);
void set_kp(unsigned char* buf, unsigned long long kp);

// relative counter of equipment time at 400(0x190) in seconds.
void extract_time(unsigned char* buf, time_t* time);
int set_time(unsigned char* buf);

#endif // PSDMODULE_H
