#!/usr/bin/perl
#  Perl ΥץΥѥ򤢤ʤδĶ˹碌ƽ񤭴Ƥ

#	[ absence.pl ] (ver.19990802)
#	----------------------------------------------------------
#	sky.pl series ˾Ƚ! 
#	Żҥ᡼α perl ץ
#		Copyright (C) 1999 
#		email address: skychore@eastmail.com
#	----------------------------------------------------------
#
#	ѹ
#	   ver. 19990802
#		եɤ %option 򻲾ȤƤߥ
#
# 	   ver. 19990801 
#		ư chore.log ˤ
#		᡼̡Υե¸褦ˤ
#		αֻ˥᡼ݴɤʤ"ʰץ⡼"
#		᡼륢ɥ쥹ȴФ
#		λ(!)ǤʤǹԤ褦ˤ
#
#	   ver. 19990601
#		᡼ӽлΥ䤷˺ľ
#	   
#	   ver. 19990308
#		˺Ѥ

# ץȤΤǥ쥯ȥ $dir_program 
$_ = $0;
if (! (($dir_program) = /(.*\/).*$/) ) {
    $dir_program = "./";
}

require $dir_program . "jcode.pl";
require $dir_program . "mimer.pl";
require $dir_program . "chore_lib.pl";

&READ_INIFILE($dir_userdata . "absence.dat");

local($email_stdin, $from, $to, $subject, $cmd_sky);
local(@weekend)       = split(/\t+/, $option{'weekend'});
local(@weekday_table) = split(/\t+/, $option{'weekday_absence_time'});
local(@holiday_table) = split(/\t+/, $option{'holiday_absence_time'});

$cmd_sky = $dir_program . "sky.pl";
$dir_spool = &INIT_DIR_SPOOL( $option{'dir_spool'} );

&MAIN;
exit;

sub MAIN {
    local($is_through);
    
    if ($option{'flush'} ne "") {
	&FLUSH("-flush ץդǵư줿",1);
	exit;
    }
    
    &GET_MAIL;
    
    $is_through = &CHECK_EMAIL_HEADER;
    
    if    ($option{'record'}) { &RECORD; exit;}

    elsif ($option{'through'}) {
	&THROUGH("-through ץդǵư줿");
	exit;
    }
    
    &READ_TIME_TABLE;
    
    if (&IS_ABSENCE_TIME) {
	if   ($is_through ) { &THROUGH($is_through);}
	else                { &RECORD;}
	
    }elsif ($is_through){	
	&THROUGH("αֳֻ");
	&FLUSH("αֳֻ˥᡼뤬Ϥ",0);
    
    }else {
	&FLUSH("αֳֻ˥᡼뤬Ϥ",0);
	&THROUGH("αֳֻ");
    }
}
	   
sub GET_MAIL {
    local($header, $name, $value, $_);
    local(@email_text);
    
    read(STDIN, $email_stdin, $option{'cutoff_byte'});
    $_ = $email_stdin;
    
    s/\015(\n)?/\n/g;
    @email_text = split(/\n/, $_);
    
    foreach (@email_text) {
	(/^$/) && last;
	if (($name,$value) = /^(\w+): (.*)/) {
	    &jcode'convert(*value, 'euc');
            &jcode'h2z_euc(*value);
	    if ($name =~ /^From/) {
		$from = &ADDRESS_PULLOUT($value);
	    }elsif ($name =~ /^To/) {
		$to = &ADDRESS_PULLOUT($value);
	    }elsif ($name =~ /^Subject/) {
		$subject = &mimedecode($value, "EUC");
	    }		
	}		
    }
    if ($from . $to . $subject eq "") {
	&ERROR("x absence.pl: ɸϤ᡼إåȴФ".
	       "Ԥޤ");
    }
}

sub RECORD {
    local($_, @files, $number, $tape_file);
    
    unless ($dir_spool) {
	&SAVE_LOG("o absence.pl: ʰץ⡼ɤưƤΤ" .
		  "Ϥ᡼¸ޤ".
		  "/From=$from; /To=$to; /Subject=$subject");
	return;
    }
    
    &LOCK_FILE($dir_userdata . "absence.dat");
    
    opendir(SPOOL, $dir_spool);
    @files = grep (/TAPE\d\d/, readdir(SPOOL));
    closedir(SPOOL);
    
    $_ = @files[@files-1];	# @filesκǸǤ
    if (($number) = /TAPE(\d\d)/) {
	if ($number == 99) { $number = 0;}
	else {	             $number++; }
    }else{
	$number=0;
    }
    
    $tape_file = "TAPE" . sprintf("%02d", $number);
    
    open(RECORD, ">$dir_spool" . $tape_file) ||
	&ERROR("x absence.pl: $tape_file 񤭹Ѥ˳ޤ");
    print RECORD $email_stdin;
    close(RECORD);
    
    &UNLOCK_FILE($dir_userdata . "absence.dat");
    
    chmod(0600, $dir_spool . $tape_file);
    &SAVE_LOG("o absence.pl: Ϥ᡼ $tape_file ¸ޤ",
	      "/From=$from; /To=$to; /Subject=$subject");
}


# ɸϤΥ᡼ sky.pl ˥ѥ
sub THROUGH {
    local($cmd_sky_option);
    local($reason) = @_;
    
    if ($option{'pipe'}) {
	$cmd_sky_option = $option{'cmd_sky_option'};
	$cmd_sky_option =~ s/\t+/ /g;
	open(PIPE, "|$cmd_sky $cmd_sky_option -dir=$dir_userdata") ||
	    &ERROR("x absence.pl: $cmd_sky إѥפǤޤǤ");
	print PIPE $email_stdin;
	close(PIPE);
    }else {
	print "absence.pl(debug-mode): Through\n";
	print "\$reason: $reason\n";
	print "--- BEGIN --- \n";
	print $email_stdin;
	print "--- END --- \n";
    }
    &SAVE_LOG("- absence.pl: $reasonΤϤ᡼̤ꤵޤ",
	      "/From=$from; /To=$to; /Subject=$subject");
}

sub FLUSH {
    local(@email_from_spool, $tmp, $counter, $_, $cmd_sky_option);
    local($reason, $verbose) = @_;
    
    # ס뤬̵ FLUSH Τʤ
    if ($dir_spool eq "") {
    	if ($verbose) {
	    &SAVE_LOG("- absence.pl: ʰץ⡼ɤưƤΤ FLUSH " .
		      "Ԥޤ");
	    return;
	}
    }
    
    &LOCK_FILE($dir_userdata . "absence.dat");
    
    opendir(SPOOL, $dir_spool);
    @files = grep (/TAPE\d\d/, readdir(SPOOL));
    closedir(SPOOL);
    
    # ס뤬ʤ᡹Ω
    if (@files+0 == 0) {
	&UNLOCK_FILE($dir_userdata . "absence.dat");
	if ($verbose) {
	    &SAVE_LOG("- absence.pl: ¸줿᡼뤬̵äΤ ".
		      "FLUSH ϹԤޤǤ");
	}
	return;
    }
    
    # ˥סƤɤߤäƤ
    # sky.pl ؤΥѥפԤƤ⥴ߤϻĤʤ
    foreach(@files) {
	open(MAIL, $dir_spool . $_);
	read(MAIL, $tmp, $option{'cutoff_byte'});
	close(MAIL);
	unlink($dir_spool . $_); # ᤤ˾äƤ
	push(@email_from_spool, $tmp);
    }
    
    # Ʊͳˤơ UNLOCK
    &UNLOCK_FILE($dir_userdata . "absence.dat");
    
    if ($option{'pipe'}) {
    	$cmd_sky_option = $option{'cmd_sky_option'};
    	$cmd_sky_option =~ s/\t+/ /g;
	
	foreach (@email_from_spool) {
	    $counter++;
	    open(PIPE,"|$cmd_sky $cmd_sky_option -dir=$dir_userdata") ||
		&ERROR("x absence.pl: $cmd_sky إѥפǤޤǤ");
	    print PIPE $_;
	    close(PIPE);
	    sleep($option{'flush_interval'});
	}
    
    }else {
	print "absence.pl(debug-mode): Flush\n";
	print "\$reason: $reason\n";
	foreach (@email_from_spool) {
	    $counter++;
	    print "Mail Number: $counter\n";
	    print "--- BEGIN --- \n";
	    print $_;
	    print "--- END --- \n\n";	 
	}
    }
    
    &SAVE_LOG("o absence.pl: $reasonΤǡƤ" . $counter .
	      "̤Υ᡼ӽФޤ");
    
    &PSUDO_CRON;
    return(1);
}
	
    
sub CHECK_EMAIL_HEADER {
    local($_, @list);
    
    local(@header) = ("From:", "To:", "Subject:");
    local(@name)   = ("from",  "to",  "subject");
    local(@value)  = ($from,   $to,   $subject);
    
    foreach (0..2) { # From  To  Subject 3Ĥ
	@condition = split(/\t+/, $option{"email_through_". $name[$_]});
	foreach $condition (@condition) {
	    if ($value[$_] =~ /$condition/){
		return("$header[$_]̲˰".
		       "($value[$_] =~ /$condition/)");
	    } 
	}
    }
    return("");
}
		

sub ADDRESS_PULLOUT {
    local($_) = @_;
    local(@address, $strings);
    
    s/\([^\(\)]*\)//g;
    s/"[^"]*"//g;
    @list = split(/,/, $_);
    
    foreach (@list) {
	if (/<([^<>]*)>/) {
	    $_ = $1;
	}
    }
    join(", ", @list);
}


sub PSUDO_CRON {
    local($_, @job);
    local($counter)=0;
    
    return if ($option{'psudo_cron'} eq "");

    @job = split(/\t+/, $option{'psudo_cron'});
    
    foreach (@job) {
	if (system($_)){
	    &SAVE_LOG("x absence.pl: ʲΥμ¹Ԥ˼Ԥޤ $_");
	} else {
	    $counter++;
	}
    }
    
    &SAVE_LOG("- absence.pl:  cron ǽˤ" . $counter . 
	      "ĤΥ¹Ԥޤ");
}


sub INIT_DIR_SPOOL {
    local($_) = @_;
    
    unless (/\//) { # ǥ쥯ȥʤ / Ĥ餤ͭǤ礦?
	return "";
    }
    
    $_ .= "/";
    s|//|/|g;
	
    if ( -d $_ ) {
	unless ( chmod(0700, $_) ) {
	    &SAVE_LOG("x absence.pl: ᡼ݴɥǥ쥯ȥ".
		      " $_ ΥѡߥåѹǤޤǤ".
		      "ʰץ⡼ɤưޤ");
	    $_ = "";}
	
    }elsif ( mkdir($_, 0700) ) {
	&SAVE_LOG("- absence.pl: ᡼ݴɥǥ쥯ȥ".
		  " $_ ޤ");
	
    }else {
	&SAVE_LOG("x absence.pl: ᡼ݴɥǥ쥯ȥ".
		  " $_ ǤޤǤ".
		  "ʰץ⡼ɤưޤ");
	$_ = "";
    }
    
    $_;
}


sub READ_TIME_TABLE {
    local($month, $date, $hour, $minute, $_, @tmp_holiday); 
        
    @tmp_holiday =   split(/\t+/, $option{'national_holiday'});
    
    foreach (@weekend) {
	if ($_ < 0  || 6 < $_ ){
	    &ERROR("x absence.pl: ե absence.dat ",
		   "ְ꤬äƤޤ0ˤ".
		   "06οǻꤷƤ");
	}
    }
        
    foreach (@tmp_holiday) {
	if( ($month, $date) = /(\d+)\.(\d+)/) {
	    (1 <= $month && $month <= 12  &&  1 <= $date && $date <= 31) ||
		&ERROR("x absence.pl: ե absence.dat ".
		       "ְ꤬äƤޤ".
		       "/\$month = $month, /\$date = $date");
	    
	}elsif (/\D/) { 
	    # ʳʸä 
	    &ERROR("x absence.pl: ե absence.dat ",
		   "˿ʳʸȤƤޤ$_");
	}else {
	    # ꤬ʤˤϡǥեȤǺ
	    $month = ((localtime(time))[4]) + 1;
	    $date = $_;
	}
	push(@national_holiday, $month);
	push(@national_holiday, $date);
    }
    @weekday_table = &MAKE_ABSENCE_TABLE("ʿ", @weekday_table);
    @holiday_table = &MAKE_ABSENCE_TABLE("", @holiday_table);
    
    return;
    
    sub MAKE_ABSENCE_TABLE {    
	local($day, @time_table) = @_;
	local($_, $hour, $minute, @return_table);
	
	if (@time_table % 2 != 0) {
	    &ERROR("x absence.pl: ե absence.dat $day",
		   "αֳϻ֤Ƚλ֤ο礤ޤ");
	}
	while (@time_table) {
	    $_ = shift(@time_table);
	    ( ($hour, $minute) = /(\d+):(\d+)/) ||
		&ERROR("x absence.pl: ե absence.dat $day",
		       "αֳϻ֤ɽְäƤޤ");
	    $start = $hour * 60 + $minute;
	    
	    $_ = shift(@time_table);
	    ( ($hour, $minute) = /(\d+):(\d+)/) ||
		&ERROR("x absence.pl: ե absence.dat $day",
		       "αֽλ֤ɽְäƤޤ");
	    $end = $hour * 60 + $minute;
	    
	    push(@return_table, $start);
	    if ($start > $end) {
		push(@return_table, 24 * 60 +0);
		push(@return_table, 0);
	    }
	    push(@return_table, $end);
	}
	return(@return_table);
    }
}

sub IS_ABSENCE_TIME {
    local($_, $month, $date);
    local(@ima) = localtime(time);    
    
    foreach (@weekend) {
	if ($_ == $ima[6] ) {
	    return ( &CHECK_TIME_TABLE(@holiday_table) );
	}
    } 

    while (@national_holiday) {
	$month = shift(@national_holiday);
	$date  = shift(@national_holiday);
	if ($month == $ima[4]+1  &&  $date == $ima[3]) {
	    return ( &CHECK_TIME_TABLE(@holiday_table) );
	}
    }
    return ( &CHECK_TIME_TABLE(@weekday_table) );

    sub CHECK_TIME_TABLE {
	local(@time_table) = @_;
	local(@ima) = localtime(time);    
	local($now) = $ima[2] * 60 + $ima[1];
	
	while(@time_table) {
	    $start = shift(@time_table);
	    $end = shift(@time_table);
	    if ($start <= $now  &&  $now <= $end) {
		return 1;
	    }
	}
	return 0;
    }
}
